<?php

	# 		Geuges Block
	# 		Namespace:		gauges
	#		Meteotemplate Block
	
	# 		Version 2.0 - Mar 27, 2016
	#		- wind direction fix
	#		- added dew point gauge
	#		- added option to limit UV maximum value
	#		- added possibility to choose compass needle and title
	#		- compatible with current block
	#		- added possibility to show time of last update

	// 	Select source for updating the current condition values. This depends on which software you use.
	// 	Possible values:
	//	"db" 		DATABASE: use data from the MySQL database used in the rest of the template (alldata table)
	//  "wl"		WEATHER LINK: will use database with UV taken from plugins folder - UV will only work if you have WL-IP plugin installed
	//  "wd" 		WEATHER DISPLAY: select this if you want your updates using the clientraw.txt
	//	"cumulus" 	CUMULUS: select this if you want to use realtime.txt generated by Cumulus
	//	"mb"		METEOBRIDGE: select this if you want to use a text file generated by Meteobridge (mbLive.txt, for this you will need the liveGaugesMB plugin, see documentation for it at meteotemplate.com).3
	//	"ws1001"	WS1001: uses data from the JSON file
	

	$currentConditions = "wd";
	
	$UVsensor = true; // UV sensor available for users with Weather Display, Cumulus, WeatherLink, Meteobridge and WS1001
	
	// 	Set the update interval in seconds. When selecting this take into account how often your text file/database is updated. Updates are performed by AJAX requests, so it should not affect the actual loading time of your homepage.

	$updateInterval = 5; // in seconds

	//	Set the path to your update file. Specify absolute or relative path to clientraw.txt/realtime.txt/mbLive.txt, if you use the option to update from database, leave blank.
	
	$filePath = "../../../../data/clientraw.txt";
	
	// ENABLED GAUGES
	// specify the gauges you want to show, in the order you want.
	// Abbreviations: T - temperature, A - apparent temperature, H - humidity, P - pressure, W - wind speed, G - wind gust, C - compass (wind direction), R - daily precipitation, UV, S - solar radiation
	//$gaugeOrder = "T,A,D,H,P,W,G,C,R,UV,S";
	$gaugeOrder = "T,D,H,P,W,G,C,R,S";
		
	$gaugeTitles = true; // enable/disable the parameter title inside the gauge
	
	$gaugeShadow = false; // add glow (shadow) to the gauges
	
	$showValuesDefault = true; // show the actual value inside the gauge
	
	$gaugeSizeDefault = 150; // default size of the gauge in pixels
	
	$animation = "linear"; // linear, quad, cycle, bounce, elastic
	
	// Specify the gauge design.
	// "template" - use template colors, "dark", "light", "black", "white", "retro"
	$gaugeDesign = "template";
	
	$circle3D = true; // add 3D look to the gauge outer circle
	
	$showTime = false; // show update time above the gauges
	
	/* INDIVIDUAL GAUGE SETTING */
	// make sure you fill in values for all the units (or leave the defaults), because you have to remember the users can change these in the settings
	
	// Temperature, apparent temperature, dew point gauge
		$minLimitC = -30; // minimum value when units set to C
		$maxLimitC = 40; // maximum value when units set to C
		$minLimitF = -30; // minimum value when units set to F
		$maxLimitF = 110; // ,maximum value when units set to F
		$majorTickIntervalT = 10; // interval between the numbers on the gauge (major ticks)
		$minorTickCountT = 10; // number of minor ticks between each major tick interval
		$highlightT = true; // undercolor the values in blue (below freezing point) and red (above freezing point)
	
	// Humidity gauge
		$majorTickIntervalH = 20; // interval between the numbers on the gauge (major ticks)
		$minorTickCountH = 4; // number of minor ticks between each major tick interval
		$highlightH = true; // green gradient undercolor
		
	// Pressure gauge
		$minLimitHPA = 980; // minimum value when units set to hPa
		$maxLimitHPA = 1040; // maximum value when units set to hPa
		$minLimitINHG = 28; // minimum value when units set to inHg
		$maxLimitINHG = 31; // maximum value when units set to inHg
		$minLimitMMHG = 730; // minimum value when units set to mmHg
		$maxLimitMMHG = 780; // maximum value when units set to mmHg
		$majorTickIntervalPHPA = 10; // interval between the numbers on the gauge (major ticks) when units set to hPa
		$majorTickIntervalPINHG = 1; // interval between the numbers on the gauge (major ticks) when units set to inHg
		$majorTickIntervalPMMHG = 10; // interval between the numbers on the gauge (major ticks) when units set to mmHg
		$minorTickCountP = 5; // number of minor ticks between each major tick interval
		
	// Wind gauge
		$WmaxLimitKMH = 80;  // maximum value when units set to km/h
		$WmaxLimitMS = 25; // maximum value when units set to m/s
		$WmaxLimitKT = 50; // maximum value when units set to knots
		$WmaxLimitMPH = 50; // maximum value when units set to mph
		$WmajorTickIntervalKMH = 10; // interval between the numbers on the gauge (major ticks) when units set to km/h
		$WmajorTickIntervalMS = 5; // interval between the numbers on the gauge (major ticks) when units set to m/s
		$WmajorTickIntervalKT = 10; // interval between the numbers on the gauge (major ticks) when units set to knots
		$WmajorTickIntervalMPH = 10; // interval between the numbers on the gauge (major ticks) when units set to mph
		$minorTickCountW = 5; // number of minor ticks between each major tick interval
	
	// Gust gauge
		$GmaxLimitKMH = 120; // maximum value when units set to km/h
		$GmaxLimitMS = 35; // maximum value when units set to m/s
		$GmaxLimitKT = 75; // maximum value when units set to knots
		$GmaxLimitMPH = 75; // maximum value when units set to mph
		$GmajorTickIntervalKMH = 10; // interval between the numbers on the gauge (major ticks) when units set to km/h
		$GmajorTickIntervalMS = 5; // interval between the numbers on the gauge (major ticks) when units set to m/s
		$GmajorTickIntervalKT = 10; // interval between the numbers on the gauge (major ticks) when units set to knots
		$GmajorTickIntervalMPH = 10; // interval between the numbers on the gauge (major ticks) when units set to mph
		$minorTickCountG = 5; // number of minor ticks between each major tick interval
		
	// Rain gauge
		$maxLimitMM = 50; // maximum value when units set to mm
		$maxLimitCM = 5; // maximum value when units set to cm
		$maxLimitIN = 2; // maximum value when units set to inches
		$majorTickIntervalMM = 5; // interval between the numbers on the gauge (major ticks) when units set to mm
		$majorTickIntervalCM = 0.5; // interval between the numbers on the gauge (major ticks) when units set to cm
		$majorTickIntervalIN = 0.2; // interval between the numbers on the gauge (major ticks) when units set to inches
		$minorTickCountR = 2; // number of minor ticks between each major tick interval
		
	// Solar radiation gauge
		$highlightS = true; // black->yellow gradient undercolor of the gauge
		
	// UV gauge
		$limitUV = true; // set this to true if you want the UV gauge to have a maximum of just 11 rather than 20
		$highlightUV = true; // UV gauge undercolor
		
	// Wind direction (compass)
		$compassNeedle = "line"; // "line" - just an indicator line on the actual compass, "arrow" - full arrow from the gauge center, just like the other gauges
		$compassTitle = true; // the label for wind direction can be set separately (it does not look very good when the line indicator is used)
		
		
?>